<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              piwebsolution.com
 * @since             2.3.32
 * @package           Pisol_Sales_Notification
 *
 * @wordpress-plugin
 * Plugin Name:       Live Sales Notifications for WooCommerce
 * Plugin URI:        https://www.piwebsolution.com/user-documentation-live-sales-notification-for-woocommerce/
 * Description:       Showing live sales notification, encourages your visitors to buy from you as they can see how others are also buying from you
 * Version:           2.3.32
 * Author:            PI Websolution
 * Author URI:        piwebsolution.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       pisol-sales-notification
 * Domain Path:       /languages
 * WC tested up to: 10.1.2
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}


/* 
    Making sure woocommerce is there 
*/
include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

if(!is_plugin_active( 'woocommerce/woocommerce.php')){
    
    add_action( 'admin_notices', function () {
        ?>
        <div class="error notice">
            <p><?php esc_html_e( 'Please Install and Activate WooCommerce plugin, without that this plugin cant work.', 'pisol-sales-notification' ); ?></p>
        </div>
        <?php
    } );
    return;
}

/**
 * Declare compatible with HPOS new order table 
 */
add_action( 'before_woocommerce_init', function() {
	if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
	}
} );

if(is_plugin_active( 'live-sales-notifications-for-woocommerce-pro/pisol-sales-notification.php')){
    deactivate_plugins(plugin_basename(__FILE__));
    return;
}else{

define('PI_SALES_NOTIFICATION_BUY_URL', 'https://www.piwebsolution.com/checkout/?add-to-cart=1320&variation_id=1321&utm_campaign=live_sales&utm_source=website&utm_medium=direct-buy');
define('PI_SALES_NOTIFICATION_PRICE', '$22');
define('PI_SALES_NOTIFICATION_DELETE_SETTING', false);
define( 'PISOL_SALES_NOTIFICATION_WOOCOMMERCE_PLUGIN_URL',  plugin_dir_url( __FILE__ )  );
/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'PISOL_SALES_NOTIFICATION_VERSION', '2.3.32' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-pisol-sales-notification-activator.php
 */
function activate_pisol_sales_notification() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-pisol-sales-notification-activator.php';
	Pisol_Sales_Notification_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-pisol-sales-notification-deactivator.php
 */
function deactivate_pisol_sales_notification() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-pisol-sales-notification-deactivator.php';
	Pisol_Sales_Notification_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_pisol_sales_notification' );
register_deactivation_hook( __FILE__, 'deactivate_pisol_sales_notification' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-pisol-sales-notification.php';

function pisol_lsnw_plugin_link( $links ) {
	$links = array_merge( array(
        '<a href="' . esc_url( admin_url( '/admin.php?page=pisol-sales-notification' ))  . '">' . esc_html__( 'Settings','pisol-sales-notification' ) . '</a>',
        '<a style="color:#0a9a3e; font-weight:bold;" target="_blank" href="' . esc_url(PI_SALES_NOTIFICATION_BUY_URL) . '">' . esc_html__( 'Buy PRO Version','pisol-sales-notification' ) . '</a>'
	), $links );
	return $links;
}
add_action( 'plugin_action_links_' . plugin_basename( __FILE__ ), 'pisol_lsnw_plugin_link' );

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_pisol_sales_notification() {

	$plugin = new Pisol_Sales_Notification();
	$plugin->run();

}
run_pisol_sales_notification();

}